import funkin.backend.MusicBeatState;
var watermark = new FlxSprite(20, 640).loadGraphic(Paths.image("stages/doc/dfearstudios"));
MusicBeatState.skipTransIn = MusicBeatState.skipTransOut = true;

public var omgBar:FlxSprite = new FlxSprite();
omgBar.frames = Paths.getFrames("game/hud/omg/OMG_BAR");
omgBar.animation.addByPrefix("loop", "OMG_HEALTHBAR", 24, true);
omgBar.scale.set(0.8, 0.8);
static var newIcon1:HealthIcon;
static var newIcon2:HealthIcon;

function onNoteCreation(event) 
	{
		event.cancel();
		var note = event.note;
		
		if (!event.cancel) 
		{
			switch (event.noteType) 
			{
				default:
					note.frames = Paths.getFrames('game/notes/flash');
				switch (event.strumID % 4 )
				{
					case 0:
						note.animation.addByPrefix('scroll', 'purple0');
						note.animation.addByPrefix('hold', 'purple hold piece');
						note.animation.addByPrefix('holdend', 'pruple end hold');
					case 1:
						note.animation.addByPrefix('scroll', 'blue0');
						note.animation.addByPrefix('hold', 'blue hold piece');
						note.animation.addByPrefix('holdend', 'blue hold end');
					case 2:
						note.animation.addByPrefix('scroll', 'green0');
						note.animation.addByPrefix('hold', 'green hold piece');
						note.animation.addByPrefix('holdend', 'green hold end');
					case 3:
						note.animation.addByPrefix('scroll', 'red0');
						note.animation.addByPrefix('hold', 'red hold piece');
						note.animation.addByPrefix('holdend', 'red hold end');
				}
				note.scale.set(0.6, 0.6);
				//note.antialiasing = true;
				note.updateHitbox();
			}
		}
	}
	function onStrumCreation(event) {
		event.cancel();
		var strum = event.strum;
	
		if (!event.cancel) {
			strum.frames = Paths.getFrames('game/notes/flash');
			strum.animation.addByPrefix('green', 'arrowUP');
			strum.animation.addByPrefix('blue', 'arrowDOWN');
			strum.animation.addByPrefix('purple', 'arrowLEFT');
			strum.animation.addByPrefix('red', 'arrowRIGHT');
			//strum.antialiasing = true;
			strum.scale.set(0.6,0.6);
			
			switch (event.strumID % 4) {
				case 0:
					strum.animation.addByPrefix("static", 'arrowLEFT0');
					strum.animation.addByPrefix("pressed", 'left press', 12, false);
					strum.animation.addByPrefix("confirm", 'left confirm', 24, false);
				case 1:
					strum.animation.addByPrefix("static", 'arrowDOWN0');
					strum.animation.addByPrefix("pressed", 'down press', 12, false);
					strum.animation.addByPrefix("confirm", 'down confirm', 24, false);
				case 2:
					strum.animation.addByPrefix("static", 'arrowUP0');
					strum.animation.addByPrefix("pressed", 'up press', 12, false);
					strum.animation.addByPrefix("confirm", 'up confirm', 24, false);
				case 3:
					strum.animation.addByPrefix("static", 'arrowRIGHT0');
					strum.animation.addByPrefix("pressed", 'right press', 12, false);
					strum.animation.addByPrefix("confirm", 'right confirm', 24, false);
			}	
			strum.updateHitbox();
		}
	}

function onPostNoteCreation(event) {
	var splashes = event.note;
	splashes.splash = "flash-splash";
}

function postCreate()
{
	for (i in [
		PlayState.instance.healthBar,
		PlayState.instance.healthBarBG,
		PlayState.instance.iconP1,
		PlayState.instance.iconP2,
		PlayState.instance.scoreTxt,
		PlayState.instance.accuracyTxt,
		PlayState.instance.missesTxt
	]) i.visible = false;
	FlxG.camera.bgColor = -1;
	watermark.cameras = [camHUD2];
	insert(0, watermark);
	omgBar.cameras = [camHUD];
	omgBar.screenCenter(FlxAxes.X);
	omgBar.y = 555;
	omgBar.animation.play('loop');
	add(omgBar);
	//omgBar.color = FlxColor.RED;
	newIcon1 = new HealthIcon(boyfriend != null ? boyfriend.getIcon() : "face", true);
    newIcon2 = new HealthIcon(dad != null ? dad.getIcon() : "face", false);
	for(i in [newIcon1, newIcon2]) {
        i.y = omgBar.y;
        i.cameras = [camHUD];
		i.antialiasing = false;
		i.screenCenter(FlxAxes.X);
        add(i);
    }
	newIcon1.x += 200;
	newIcon2.x -= 200;

}
function onNoteHit(event) {
	if (event.character == strumLines.members[0].characters[0]) if (health > 0.1) event.healthGain += 0.02;
	
}
var intendedScale1;
var intendedScale2;
function update(elapsed:Float){
    newIcon1.health = healthBar.percent / 100;
    newIcon2.health = 1 - (healthBar.percent / 100);
	intendedScale1 = 1 + health/5-0.2;
	intendedScale2 = 1 - health/5+0.2;
	//trace(intendedScale1);
	newIcon1.scale.set(FlxMath.lerp(newIcon1.scale.x, intendedScale1, 0.1), FlxMath.lerp(newIcon1.scale.y, intendedScale1, 0.1));
	newIcon2.scale.set(FlxMath.lerp(newIcon2.scale.x, intendedScale2, 0.1), FlxMath.lerp(newIcon2.scale.y, intendedScale2, 0.1));
}
